<?php
include "../config/auth.php";
include "../config/koneksi.php";

if($_SESSION['role'] != "admin"){
    header("location:../login.html");
    exit;
}

$bulan = $_GET['bulan'] ?? date('m');
$tahun = $_GET['tahun'] ?? date('Y');

$data = mysqli_query($conn,"
SELECT DATE(tanggal) as tgl, SUM(total) as total_harian
FROM penjualan
WHERE MONTH(tanggal)='$bulan' AND YEAR(tanggal)='$tahun'
GROUP BY DATE(tanggal)
ORDER BY tgl ASC
");

$tanggal = [];
$total   = [];

while($row = mysqli_fetch_assoc($data)){
    $tanggal[] = date('d-m-Y', strtotime($row['tgl']));
    $total[]   = $row['total_harian'];
}
?>
<!DOCTYPE html>
<html>
<head>
<title>Grafik Penjualan</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
</head>
<body>

<div class="container mt-4">
<h3>Grafik Penjualan</h3>

<!-- FILTER -->
<form method="get" class="row g-2 mb-4">
    <div class="col-md-3">
        <select name="bulan" class="form-control">
            <?php for($i=1;$i<=12;$i++): ?>
            <option value="<?= sprintf('%02d',$i) ?>" 
                <?= ($bulan==$i?'selected':'') ?>>
                <?= date('F', mktime(0,0,0,$i,1)) ?>
            </option>
            <?php endfor ?>
        </select>
    </div>
    <div class="col-md-3">
        <input type="number" name="tahun" class="form-control" value="<?= $tahun ?>">
    </div>
    <div class="col-md-3">
        <button class="btn btn-primary">Tampilkan</button>
    </div>
</form>

<!-- GRAFIK -->
<canvas id="grafikPenjualan"></canvas>

<a href="dashboard.php" class="btn btn-secondary mt-3">Kembali</a>
</div>

<script>
const ctx = document.getElementById('grafikPenjualan');

new Chart(ctx, {
    type: 'line',
    data: {
        labels: <?= json_encode($tanggal) ?>,
        datasets: [{
            label: 'Total Penjualan (Rp)',
            data: <?= json_encode($total) ?>,
            borderWidth: 2,
            tension: 0.3
        }]
    },
    options: {
        responsive: true,
        scales: {
            y: {
                beginAtZero: true
            }
        }
    }
});
</script>

</body>
</html>
