<?php
include "../config/auth.php";
include "../config/koneksi.php";

/* HANYA ADMIN */
if($_SESSION['role'] != 1){
    header("location:../login.html");
    exit;
}

/* FILTER TANGGAL */
$dari   = $_GET['dari']   ?? '';
$sampai= $_GET['sampai'] ?? '';

$where = "";
if($dari && $sampai){
    $where = "WHERE t.tanggal BETWEEN '$dari' AND '$sampai'";
}

/* DATA TRANSAKSI */
$data = mysqli_query($conn,"
    SELECT t.*, u.nama 
    FROM transaksi t
    JOIN users u ON t.id_user = u.id_user
    $where
    ORDER BY t.tanggal DESC
");

/* TOTAL */
$total = mysqli_fetch_assoc(mysqli_query($conn,"
    SELECT SUM(total) AS total_penjualan FROM transaksi t $where
"));
?>

<!DOCTYPE html>
<html>
<head>
<title>Laporan Penjualan</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
</head>
<body class="bg-light">

<!-- SIDEBAR (SAMA PERSIS DENGAN TRANSAKSI) -->
<?php include "../includes/sidebar.php"; ?>

<!-- KONTEN -->
<div class="content" style="margin-left:250px; padding:20px;">

    <!-- HEADER -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2>Laporan Penjualan</h2>
        <div class="text-muted">
            Role: <b>Admin : <?= $_SESSION['nama']; ?></b>
        </div>
    </div>

    <!-- FILTER -->
    <form method="get" class="row g-2 mb-3">
        <div class="col-md-3">
            <input type="date" name="dari" value="<?= $dari ?>" class="form-control">
        </div>
        <div class="col-md-3">
            <input type="date" name="sampai" value="<?= $sampai ?>" class="form-control">
        </div>
        <div class="col-md-2">
            <button class="btn btn-primary w-100">
                <i class="fa fa-filter"></i> Filter
            </button>
        </div>
    </form>

    <!-- TOTAL -->
    <div class="alert alert-success">
        <i class="fa fa-money-bill"></i>
        <b>Total Penjualan:</b>
        Rp <?= number_format($total['total_penjualan'] ?? 0) ?>
    </div>

    <!-- TABEL -->
    <table class="table table-bordered table-striped">
        <tr class="table-dark">
            <th>No</th>
            <th>Tanggal</th>
            <th>Kasir</th>
            <th>Total</th>
        </tr>

        <?php $no=1; while($t=mysqli_fetch_assoc($data)): ?>
        <tr>
            <td><?= $no++ ?></td>
            <td><?= $t['tanggal'] ?></td>
            <td><?= $t['nama'] ?></td>
            <td>Rp <?= number_format($t['total']) ?></td>
        </tr>
        <?php endwhile; ?>
    </table>

    <a href="../admin/index.php" class="btn btn-secondary">
        <i class="fa fa-arrow-left"></i> Kembali
    </a>

</div>

</body>
</html>
