<?php
include "../config/auth.php";
include "../config/koneksi.php";

$data = mysqli_query($conn, "SELECT * FROM produk");
?>

<!DOCTYPE html>
<html>
<head>
<title>Data Produk</title>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css">
</head>
<body>

<div class="container mt-4">
    <h3>Data Produk</h3>

    <?php if($_SESSION['role'] != 3): ?>
    <a href="tambah_produk.php" class="btn btn-primary mb-2">Tambah Produk</a>
    <?php endif; ?>

    <table class="table table-bordered">
        <tr class="table-dark">
            <th>No</th>
            <th>Nama Produk</th>
            <th>Harga</th>
            <th>Stok</th>
            <th>Aksi</th>
        </tr>

        <?php $no=1; while($row=mysqli_fetch_assoc($data)): ?>
        <tr>
            <td><?= $no++ ?></td>
            <td><?= $row['nama_produk'] ?></td>
            <td><?= number_format($row['harga']) ?></td>
            <td><?= $row['stok'] ?></td>
            <td>
                <?php if($_SESSION['role'] != 3): ?>
                <a href="edit_produk.php?id=<?= $row['id_produk'] ?>" class="btn btn-warning btn-sm">Edit</a>
                <a href="hapus_produk.php?id=<?= $row['id_produk'] ?>" 
                   class="btn btn-danger btn-sm"
                   onclick="return confirm('Hapus data?')">Hapus</a>
                <?php else: ?>
                -
                <?php endif; ?>
            </td>
        </tr>
        <?php endwhile ?>
    </table>

    <?php
    if($_SESSION['role'] == 1){
        $kembali = "../admin/index.php";
    }elseif($_SESSION['role'] == 2){
        $kembali = "../kasir/index.php";
    }else{
        $kembali = "../user/index.php";
    }
    ?>

    <a href="<?= $kembali ?>" class="btn btn-secondary mt-3">
        Kembali ke Dashboard
    </a>
</div>

</body>
</html>
