<?php
include "../config/auth.php";
include "../config/koneksi.php";

// Proteksi khusus USER
if($_SESSION['role'] != 3){
    header("location:../login.html");
    exit;
}

$data = mysqli_query($conn, "SELECT * FROM produk ORDER BY nama_produk ASC");
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Daftar Produk</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
</head>
<body class="bg-light">

<?php include "../includes/sidebar.php"; ?>

<div class="content" style="margin-left: 250px; padding: 20px;">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2>Daftar Produk</h2>
        <div class="text-muted">User: <b><?= $_SESSION['nama'] ?></b></div>
    </div>

<nav class="navbar navbar-dark bg-info">
    <div class="container">
        <span class="navbar-brand">Daftar Produk</span>
        <span class="text-white">
            User: <b><?= $_SESSION['nama'] ?></b>
        </span>
    </div>
</nav>

<div class="container mt-4">

    <div class="row">
        <?php while($p = mysqli_fetch_assoc($data)): ?>
        <div class="col-md-4">
            <div class="card shadow mb-3">
                <div class="card-body text-center">
                    <h5 class="card-title"><?= $p['nama_produk'] ?></h5>
                    <p class="card-text">
                        Harga: <b>Rp <?= number_format($p['harga']) ?></b><br>
                        Stok: <?= $p['stok'] ?>
                    </p>
                </div>
            </div>
        </div>
        <?php endwhile ?>
    </div>

    <a href="../user/index.php" class="btn btn-secondary mt-3">Kembali</a>
</div>

</body>
</html>
