<?php
include "../config/auth.php";
include "../config/koneksi.php";

if($_SESSION['role'] != 1 && $_SESSION['role'] != 2){
    header("location:../login.html");
    exit;
}

$data = mysqli_query($conn,"
    SELECT p.*, u.nama
    FROM penjualan p
    JOIN users u ON p.id_user=u.id_user
    ORDER BY p.id_penjualan DESC
");
?>

<!DOCTYPE html>
<html>
<head>
<title>Data Transaksi</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
</head>
<body class="bg-light">

<!-- SIDEBAR -->
<?php include "../includes/sidebar.php"; ?>

<!-- KONTEN -->
<div class="content" style="margin-left:250px; padding:20px;">

    <!-- HEADER -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2>Data Transaksi</h2>
        <div class="text-muted">
            Role:
            <b>
                <?= $_SESSION['role']==1 ? 'Admin' : 'Kasir'; ?> :
                <?= $_SESSION['nama']; ?>
            </b>
        </div>
    </div>

    <a href="tambah.php" class="btn btn-primary mb-3">
        <i class="fa fa-plus"></i> Transaksi Baru
    </a>

    <table class="table table-bordered table-striped">
    <thead class="table-dark">
    <tr>
        <th style="width:50px">No</th>
        <th style="width:180px">Tanggal</th>
        <th>Kasir</th>
        <th style="width:150px">Total</th>
        <th style="width:120px">Aksi</th>
    </tr>
    </thead>
    <tbody>

        <?php $no=1; while($t=mysqli_fetch_assoc($data)): ?>
        <tr>
            <!-- NO -->
            <td><?= $no++ ?></td>

            <!-- TANGGAL -->
            <td>
                <?= date('Y-m-d', strtotime($t['tanggal'])) ?><br>
                <small class="text-muted">
                    <?= date('H:i:s', strtotime($t['tanggal'])) ?>
                </small>
            </td>

            <!-- KASIR -->
            <td><?= $t['nama'] ?></td>

            <!-- TOTAL -->
            <td>Rp <?= number_format($t['total']) ?></td>

            <td>
                <!-- DETAIL -->
                <a href="detail.php?id=<?= $t['id_penjualan'] ?>" 
                    class="btn btn-info btn-sm" 
                    title="Detail">
                    <i class="fa fa-eye"></i>
                </a>

                <!-- CETAK STRUK -->
                <a href="cetak.php?id=<?= $t['id_penjualan'] ?>" 
                    target="_blank"
                    class="btn btn-success btn-sm"
                    title="Cetak Struk">
                    <i class="fa fa-print"></i>
                </a>
            </td>

        </tr>
        <?php endwhile ?>
    </tbody>
    </table>


    <?php
    if($_SESSION['role'] == 1){
        $kembali = "../admin/index.php";
    }else{
        $kembali = "../kasir/index.php";
    }
    ?>

    <a href="<?= $kembali ?>" class="btn btn-secondary">
        <i class="fa fa-arrow-left"></i> Kembali
    </a>

</div>

</body>
</html>
