<?php
include "../config/auth.php";
cekLogin();
cekRole([3]); // ROLE USER
?>

<!DOCTYPE html>
<html>
<head>
<title>Riwayat Transaksi</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
</head>
<body class="bg-light">

<?php include "../includes/sidebar_user.php"; ?>

<div class="content" style="margin-left:250px; padding:20px;">

<h3>Riwayat Transaksi Saya</h3>

<table class="table table-bordered table-striped">
<thead class="table-dark">
<tr>
    <th>No</th>
    <th>Tanggal</th>
    <th>Total</th>
    <th>Aksi</th>
</tr>
</thead>
<tbody>

<?php $no=1; while($t=mysqli_fetch_assoc($data)): ?>
<tr>
    <td><?= $no++ ?></td>
    <td>
        <?= date('Y-m-d', strtotime($t['tanggal'])) ?><br>
        <small class="text-muted">
            <?= date('H:i:s', strtotime($t['tanggal'])) ?>
        </small>
    </td>
    <td>Rp <?= number_format($t['total']) ?></td>
    <td>
        <a href="detail.php?id=<?= $t['id_transaksi'] ?>" 
            class="btn btn-info btn-sm">
            <i class="fa fa-eye"></i> Detail
        </a>
    </td>
</tr>
<?php endwhile ?>

<?php if(mysqli_num_rows($data) == 0): ?>
<tr>
    <td colspan="4" class="text-center text-muted">
        Belum ada transaksi
    </td>
</tr>
<?php endif; ?>

</tbody>
</table>

<a href="index.php" class="btn btn-secondary">
    <i class="fa fa-arrow-left"></i> Kembali
</a>

</div>
</body>
</html>
